/**
*    Fade.cpp
*    
*    Extention of Routine randomly fade the cube in and out.
*    
*    Program written by Lopuz3
*    Spring 2013 
**/

#include "Arduino.h"
#include "Fade.h"

Fade::Fade()
{
	numLeft = CUBE_SIZE*CUBE_SIZE*CUBE_SIZE;
	timeSinceLastStep = 0;
	lighting = true;
}

void Fade::update(unsigned long dt)
{
	timeSinceLastStep += dt;
	if (timeSinceLastStep > STEP_TIME)
	{
		int toToggle = random(numLeft);
		int unchangedCounter = 0;
		for(byte x = 0 ; x < CUBE_SIZE ; x++)
		{
			for(byte y = 0 ; y < CUBE_SIZE ; y++)
			{
				for(byte z = 0 ; z < CUBE_SIZE ; z++)
				{
					if(lighting != cubeModel[x][y][z])
					{
						if(unchangedCounter == toToggle)
						{
							cubeModel[x][y][z] = lighting;
							numLeft--;
						}
						unchangedCounter++;
					}
				}
			}
		}
		if(numLeft == 0)
		{
			numLeft = CUBE_SIZE*CUBE_SIZE*CUBE_SIZE;
			lighting = !lighting;
		}
		timeSinceLastStep -= STEP_TIME;
	}
}

